/*-------------------------------------------------------------------------*\
  <ikbbuffer.c> -- Identical Software's Buffered Keyboard Routines
    (Linux SDL version)

  Date      Programmer  Description
  10/09/99  Dennis      Created.
\*-------------------------------------------------------------------------*/
#include <ikbbuffer.h>
#include <SDL.h>

/* The buffer size must be one less than a multiple of two */
#define IBUFFERSIZE   15
#define ILEFTSHIFT    1
#define IRIGHTSHIFT   2
#define ILEFTCONTROL  4
#define IRIGHTCONTROL 8
#define ILEFTALT      16
#define IRIGHTALT     32

void IKeybufferHandler(int waitEvent);

unsigned char IKeybufferMap[2][4][128] = {
 { /* Lower keys 0 - 127 */
/*{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0x09, 0xFF, 0xFF,
    0xFF, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, ' ' , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, '\'', 0xFF, 0xFF, 0xFF, 0xFF, ',' , '-' , '.' , '/' ,
    '0' , '1' , '2' , '3' , '4' , '5' , '6' , '7' , '8' , '9' , 0xFF, ';' ,
    0xFF, '=' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, '[' , '\\', ']' , 0xFF, 0xFF,
    '`' , 'a' , 'b' , 'c' , 'd' , 'e' , 'f' , 'g' , 'h' , 'i' , 'j' , 'k' ,
    'l' , 'm' , 'n' , 'o' , 'p' , 'q' , 'r' , 's' , 't' , 'u' , 'v' , 'w' ,
    'x' , 'y' , 'z' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, */
  /* Normal */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0x09, 0xFF, 0xFF,
    0xFF, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, ' ' , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, '\'', 0xFF, 0xFF, 0xFF, 0xFF, ',' , '-' , '.' , '/' ,
    '0' , '1' , '2' , '3' , '4' , '5' , '6' , '7' , '8' , '9' , 0xFF, ';' ,
    0xFF, '=' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, '[' , '\\', ']' , 0xFF, 0xFF,
    '`' , 'a' , 'b' , 'c' , 'd' , 'e' , 'f' , 'g' , 'h' , 'i' , 'j' , 'k' ,
    'l' , 'm' , 'n' , 'o' , 'p' , 'q' , 'r' , 's' , 't' , 'u' , 'v' , 'w' ,
    'x' , 'y' , 'z' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  /* Shift */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0x09, 0xFF, 0xFF,
    0xFF, 0x0D, 0xFF, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ' ' , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, '"' , 0xFF, 0xFF, 0xFF, 0xFF, '<' , '_' , '>' , '?' ,
    ')' , '!' , '@' , '#' , '$' , '%' , '^' , '&' , '*' , '(' , 0xFF, ':' ,
    0xFF, '+' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, '{' , '|' , '}' , 0xFF, 0xFF,
    '~' , 'A' , 'B' , 'C' , 'D' , 'E' , 'F' , 'G' , 'H' , 'I' , 'J' , 'K' ,
    'L' , 'M' , 'N' , 'O' , 'P' , 'Q' , 'R' , 'S' , 'T' , 'U' , 'V' , 'W' ,
    'X' , 'Y' , 'Z' , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  /* Control */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0x09, 0xFF, 0xFF,
    0xFF, 0x0D, 0xFF, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ' ' , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0xFF, 0xFF,
    0x88, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0xFF, 0x8A,
    0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xFF, 0x1D, 0xFF, 0xFF,
    0xFF, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
    0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  /* Alt */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0x09, 0xFF, 0xFF,
    0xFF, 0x0D, 0xFF, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ' ' , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x94, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x9F, 0xAC, 0xAA, 0xA1, 0x97, 0xA2, 0xA3, 0xA4, 0x9C, 0xA5, 0xA6,
    0xA7, 0xAE, 0xAD, 0x9D, 0x9E, 0x95, 0x98, 0xA0, 0x99, 0x9B, 0xAB, 0x96,
    0xA9, 0x9A, 0xA8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
 },
 { /* Upper keys 256 - 383 */
/*{ 0xFF, 0xFF, DOWN, 0xFF, LEFT, CNTR, RGHT, 0xFF,  UP , 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  UP , DOWN, RGHT, LEFT, INS , HOME, END ,
    PGUP, PGDN,  F1 ,  F2 ,  F3 ,  F4 ,  F5 ,  F6 ,  F7 ,  F8 ,  F9 , F10 ,
    F11 , F12 , 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, */
  /* Normal */
  { 0xFF, 0xFF, 0xC3, 0xFF, 0xBF, 0xC0, 0xC1, 0xFF, 0xBD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBD, 0xC3, 0xC1, 0xBF, 0xC5, 0xBC, 0xC2,
    0xBE, 0xC4, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
    0xB9, 0xBA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  /* Shift */
  { 0xFF, 0xFF, 0xDA, 0xFF, 0xD6, 0xD7, 0xD8, 0xFF, 0xD4, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0xDA, 0xD8, 0xD6, 0xDC, 0xD3, 0xD9,
    0xD5, 0xDB, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0,
    0xD1, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  /* Control (Unfinished) */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDE, 0xDF, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4 },
  /* Alt (Unfinished) */
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
 }
};

unsigned char IKeybufferBuffer[IBUFFERSIZE+1];
int IKeybufferFirst, IKeybufferLast;
int IKeybufferModify;

void IKeybufferStart()
{
 IKeybufferFirst = IKeybufferLast = IKeybufferModify = 0;
 SDL_EventState(SDL_ACTIVEEVENT, SDL_IGNORE);
 SDL_EventState(SDL_MOUSEMOTION, SDL_IGNORE);
 SDL_EventState(SDL_MOUSEBUTTONDOWN, SDL_IGNORE);
 SDL_EventState(SDL_MOUSEBUTTONUP, SDL_IGNORE);
 SDL_EventState(SDL_QUIT, SDL_IGNORE);
 SDL_EventState(SDL_SYSWMEVENT, SDL_IGNORE);
}

unsigned char IKeybufferGet()
{
 unsigned char c;

 /* The ALT - F# keys do not currently function under Linux */
 while (IKeybufferFirst == IKeybufferLast)
 {
  /* if no characters in the buffer wait until there are */
  IKeybufferHandler(1);
 }
 c = IKeybufferBuffer[IKeybufferFirst];
 IKeybufferFirst++;
 IKeybufferFirst &= IBUFFERSIZE;
 return c;
}

void IKeybufferHandler(int waitEvent)
{
 SDL_Event sdlevent;
 int avail;
 int mask, table;

 while (IKeybufferFirst == IKeybufferLast)
 {
  for (avail = (waitEvent ? SDL_WaitEvent(&sdlevent) : SDL_PollEvent(&sdlevent));
    avail;
    avail = SDL_PollEvent(&sdlevent))
  {
   if ((sdlevent.type == SDL_KEYDOWN) || (sdlevent.type == SDL_KEYUP))
   {
    switch (sdlevent.key.keysym.sym)
    {
     case SDLK_LCTRL:
      mask = ILEFTCONTROL;
      break;
     case SDLK_RCTRL:
      mask = IRIGHTCONTROL;
      break;
     case SDLK_LALT:
      mask = ILEFTALT;
      break;
     case SDLK_RALT:
      mask = IRIGHTALT;
      break;
     case SDLK_LSHIFT:
      mask = ILEFTSHIFT;
      break;
     case SDLK_RSHIFT:
      mask = IRIGHTSHIFT;
      break;
     default:
      if ((sdlevent.type == SDL_KEYDOWN) &&
        (((IKeybufferFirst + 1) & IBUFFERSIZE) != IKeybufferLast))
      {
       if ((IKeybufferModify & IRIGHTALT) || (IKeybufferModify & ILEFTALT))
       {
        mask = 3;
       }
       else if ((IKeybufferModify & IRIGHTCONTROL) ||
         (IKeybufferModify & ILEFTCONTROL))
       {
        mask = 2;
       }
       else if ((IKeybufferModify & IRIGHTSHIFT) ||
         (IKeybufferModify & ILEFTSHIFT))
       {
        mask = 1;
       }
       else
       {
        mask = 0;
       }
       if (sdlevent.key.keysym.sym < 128)
       {
        table = 0;
       }
       else if ((sdlevent.key.keysym.sym & 0xF180) == 0x0100)
       {
        table = 1;
       }
       else
       {
        table = -1;
       }
       if ((table >= 0) &&
         (IKeybufferMap[table][mask][sdlevent.key.keysym.sym & 0x7F] != 0xFF))
       {
        IKeybufferBuffer[IKeybufferLast] =
          IKeybufferMap[table][mask][sdlevent.key.keysym.sym & 0x7F];
        IKeybufferLast++;
        IKeybufferLast &= IBUFFERSIZE;
       }
      }
      return ;
      break;
    }
    if (sdlevent.type == SDL_KEYDOWN)
    {
     IKeybufferModify |= mask;
    }
    else
    {
     IKeybufferModify &= ~mask;
    }
   }
  }
 }
}

unsigned char IKeybufferPress()
{
 SDL_Event sdlevent;
 int avail;
 int mask, table;

 IKeybufferHandler(0);
 return (IKeybufferFirst != IKeybufferLast);
}

